﻿//////////////////////////////////////////////
// ScriptStrategy.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Script ;
}

/// Includes ---------------------------------

// nkScripts
#include "../CompilationResult.h"

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkScripts
{
	class ScriptStrategy
	{
		public :

			// Constructeur, destructeur
			ScriptStrategy (Script* parentHolder) noexcept ;
			virtual ~ScriptStrategy () ;

			// Getters
			const CompilationResult& getLastCompilationResult () const ;

			// Loading
			virtual bool load (nkMemory::StringView sources) = 0 ;
			virtual void unload () = 0 ;

		protected :

			// Attributes
			// Holder parent
			Script* _parentHolder ;

			// Resultat de compilation
			CompilationResult _lastCompilationResult ;
	} ;
}